#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <set>

using namespace std;

typedef long long ll;

int main() {
    
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    
    set<ll> proizvodi_set;
    vector<ll> q;
    proizvodi_set.insert(1);
    q.push_back(1);

    ll granica = 1e18;
    int head = 0;
    while(head < q.size()){
        ll trenutni = q[head++];
        for(int d = 2; d <= 9; ++d){
            
            if(trenutni > granica / d) continue;
            ll sledeci = trenutni * d;
            if(proizvodi_set.find(sledeci) == proizvodi_set.end()){
                proizvodi_set.insert(sledeci);
                q.push_back(sledeci);
            }
        }
    }

    vector<ll> sortirani(proizvodi_set.begin(), proizvodi_set.end());

    int T;
    if(!(cin >> T)) return 0;
    while(T--){
        string s_n;
        cin >> s_n;
        ll n = stoll(s_n);

        if(n < 10){
            cout << n << "\n";
            continue;
        }

       
        ll max_p = 1;
        for(int i = 0; i < s_n.size() - 1; ++i) max_p *= 9;

        ll p_n = 1;
        bool ima_nulu = false;
        for(char c : s_n){
            if(c == '0'){ ima_nulu = true; break; }
            p_n *= (c - '0');
        }
        if(!ima_nulu) max_p = max(max_p, p_n);

       
        auto it = upper_bound(sortirani.begin(), sortirani.end(), max_p);
        ll rez = distance(sortirani.begin(), it);
        
        
        cout << rez + 1 << "\n";
    }

    return 0;
}